#include <iostream>
#include <vector>
using namespace std;

int main() {
    while (true) {
        int l, c, t;
        cin >> l >> c >> t;

        if (l == 0 && c == 0 && t == 0) {
            break;
        }

        // Cria a matriz original
        vector<vector<int>> original(l, vector<int>(c));
        for (int i = 0; i < l; i++) {
            for (int j = 0; j < c; j++) {
                original[i][j] = c * i + j + 1;
            }
        }

        // Vetores para controlar linhas e colunas
        vector<int> linha(l), coluna(c);
        for (int i = 0; i < l; i++) {
            linha[i] = i;
        }
        for (int j = 0; j < c; j++) {
            coluna[j] = j;
        }

        // Processa as operações
        for (int opCount = 0; opCount < t; opCount++) {
            char op;
            int a, b;
            cin >> op >> a >> b;
            a--; b--;

            if (op == 'L') {
                swap(linha[a], linha[b]);
            } else {
                swap(coluna[a], coluna[b]);
            }
        }

        // Gera a resposta
        vector<vector<int>> resposta(l, vector<int>(c));
        for (int i = 0; i < l; i++) {
            for (int j = 0; j < c; j++) {
                resposta[i][j] = original[linha[i]][coluna[j]];
            }
        }

        // Imprime a resposta
        for (int i = 0; i < l; i++) {
            for (int j = 0; j < c; j++) {
                cout << resposta[i][j] << (j == c - 1 ? "\n" : " ");
            }
        }
    }

    return 0;
}
